// Heise.iX.Autor
using System;
using System.Collections.Generic;
using System.Runtime.CompilerServices;
using System.Text;
using Heise.iX;

public readonly struct Autor : IEquatable<Autor>
{
	public int ID { get; init; }

	public string? Name { get; init; }

	public int ArtikelAnzahl { get; init; }

	public int Alter { get; init; }

	public string Wohnort { get; init; }

	public List<Firma> Firmen { get; init; }

	public DateOnly ErsterBeitrag { get; init; }

	public Autor(int ID, string? Name, int ArtikelAnzahl = 0)
	{
		this.ID = ID;
		this.Name = Name;
		this.ArtikelAnzahl = ArtikelAnzahl;
		Alter = 0;
		Wohnort = "";
		Firmen = new List<Firma>();
	}

	public void Check(int yearMin, int yearMax, [CallerArgumentExpression("yearMin")] string? yearMinExpression = null, [CallerArgumentExpression("yearMax")] string? yearMaxExpression = null)
	{
		if (ErsterBeitrag.Year < yearMin || ErsterBeitrag.Year > yearMax)
		{
			DefaultInterpolatedStringHandler defaultInterpolatedStringHandler = new DefaultInterpolatedStringHandler(34, 5);
			defaultInterpolatedStringHandler.AppendFormatted(ErsterBeitrag);
			defaultInterpolatedStringHandler.AppendLiteral(" muss zwischen ");
			defaultInterpolatedStringHandler.AppendFormatted(yearMin);
			defaultInterpolatedStringHandler.AppendLiteral(" (");
			defaultInterpolatedStringHandler.AppendFormatted(yearMinExpression);
			defaultInterpolatedStringHandler.AppendLiteral(") und ");
			defaultInterpolatedStringHandler.AppendFormatted(yearMax);
			defaultInterpolatedStringHandler.AppendLiteral(" (");
			defaultInterpolatedStringHandler.AppendFormatted(yearMaxExpression);
			defaultInterpolatedStringHandler.AppendLiteral(") liegen!");
			throw new ArgumentOutOfRangeException("ErsterBeitrag", defaultInterpolatedStringHandler.ToStringAndClear());
		}
	}

	public override string ToString()
	{
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.Append("Autor");
		stringBuilder.Append(" { ");
		if (PrintMembers(stringBuilder))
		{
			stringBuilder.Append(' ');
		}
		stringBuilder.Append('}');
		return stringBuilder.ToString();
	}

	private bool PrintMembers(StringBuilder builder)
	{
		builder.Append("ID = ");
		builder.Append(ID.ToString());
		builder.Append(", Name = ");
		builder.Append((object?)Name);
		builder.Append(", ArtikelAnzahl = ");
		builder.Append(ArtikelAnzahl.ToString());
		builder.Append(", Alter = ");
		builder.Append(Alter.ToString());
		builder.Append(", Wohnort = ");
		builder.Append((object?)Wohnort);
		builder.Append(", Firmen = ");
		builder.Append(Firmen);
		builder.Append(", ErsterBeitrag = ");
		builder.Append(ErsterBeitrag.ToString());
		return true;
	}

	public static bool operator !=(Autor left, Autor right)
	{
		return !(left == right);
	}

	public static bool operator ==(Autor left, Autor right)
	{
		return left.Equals(right);
	}

	public override int GetHashCode()
	{
		return (((((EqualityComparer<int>.Default.GetHashCode(ID) * -1521134295 + EqualityComparer<string>.Default.GetHashCode(Name)) * -1521134295 + EqualityComparer<int>.Default.GetHashCode(ArtikelAnzahl)) * -1521134295 + EqualityComparer<int>.Default.GetHashCode(Alter)) * -1521134295 + EqualityComparer<string>.Default.GetHashCode(Wohnort)) * -1521134295 + EqualityComparer<List<Firma>>.Default.GetHashCode(Firmen)) * -1521134295 + EqualityComparer<DateOnly>.Default.GetHashCode(ErsterBeitrag);
	}

	public override bool Equals(object obj)
	{
		return obj is Autor && Equals((Autor)obj);
	}

	public bool Equals(Autor other)
	{
		return EqualityComparer<int>.Default.Equals(ID, other.ID) && EqualityComparer<string>.Default.Equals(Name, other.Name) && EqualityComparer<int>.Default.Equals(ArtikelAnzahl, other.ArtikelAnzahl) && EqualityComparer<int>.Default.Equals(Alter, other.Alter) && EqualityComparer<string>.Default.Equals(Wohnort, other.Wohnort) && EqualityComparer<List<Firma>>.Default.Equals(Firmen, other.Firmen) && EqualityComparer<DateOnly>.Default.Equals(ErsterBeitrag, other.ErsterBeitrag);
	}

	public void Deconstruct(out int ID, out string? Name, out int ArtikelAnzahl)
	{
		ID = this.ID;
		Name = this.Name;
		ArtikelAnzahl = this.ArtikelAnzahl;
	}
}
